local original_silence

local function new_silence(wielder, weapon)
  if weapon == nil then return end
	if not weapon:IsWeapon() or not weapon:isRanged() then return; end
    local scriptItem = weapon:getScriptItem()

    local soundVolume = scriptItem:getSoundVolume()
    local soundRadius = scriptItem:getSoundRadius()
    local swingSound = scriptItem:getSwingSound()

    local canon = weapon:getCanon()
    if canon then
  		if string.find(canon:getType(), "Silencer") then
  			if weapon:getWeaponReloadType() == "handgun" then
          if weapon:getAmmoType() == "Bullets9mm" then
    	      soundVolume = soundVolume *  (0.6)
    	      soundRadius = soundRadius * (0.2)
          elseif weapon:getAmmoType() == "Bullets45" then
            soundVolume = soundVolume *  (0.7)
    	      soundRadius = soundRadius * (0.3)
          else
          soundVolume = soundVolume *  (0.6)
          soundRadius = soundRadius * (0.2)
          end
  	      swingSound = 'FirearmPistolSilencerShot'
  	    elseif weapon:getWeaponReloadType() == "boltaction" or weapon:getWeaponReloadType() == "boltactionnomag" then
  	      soundVolume = soundVolume *  (1)
  	      soundRadius = soundRadius * (0.1)
  	      swingSound = 'FirearmRifleSilencerShot'
  			end
      elseif string.find(canon:getType(), "ImprovisedSilencer") then
        if weapon:getWeaponReloadType() == "handgun" then
          if weapon:getAmmoType() == "Bullets9mm" then
            soundVolume = soundVolume *  (1)
            soundRadius = soundRadius * (0.4)
          elseif weapon:getAmmoType() == "Bullets45" then
            soundVolume = soundVolume *  (1)
            soundRadius = soundRadius * (0.5)
          else
            soundVolume = soundVolume *  (1)
            soundRadius = soundRadius * (0.4)
          end
          swingSound = 'FirearmPistolSilencerShot'
        elseif weapon:getWeaponReloadType() == "boltaction" or weapon:getWeaponReloadType() == "boltactionnomag " then
          soundVolume = soundVolume *  (1)
          soundRadius = soundRadius * (0.3)
          swingSound = 'FirearmRifleSilencerShot'
        end
      end
    end

    weapon:setSoundVolume(soundVolume)
    weapon:setSoundRadius(soundRadius)
    weapon:setSwingSound(swingSound)
end

Events.OnGameBoot.Add(function()
    Events.OnEquipPrimary.Remove(silence);
    Events.OnEquipPrimary.Add(new_silence);
    -- store the original function. Note we dont store until we're ready to overwrite
    original_silence = silence
    -- now overwrite
    silence = new_silence
end)

Events.OnGameStart.Add(function() -- make sure our player is setup on game start
	local player = getPlayer()
	new_silence(player, player:getPrimaryHandItem())
end)
